"use strict";
exports.id = 1790;
exports.ids = [1790];
exports.modules = {

/***/ 39794:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ useGetBasicCampaigns)
/* harmony export */ });
/* harmony import */ var _MainApi__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61176);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67759);
/* harmony import */ var _ApiRoutes__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(60274);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_MainApi__WEBPACK_IMPORTED_MODULE_0__, _api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_2__]);
([_MainApi__WEBPACK_IMPORTED_MODULE_0__, _api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




const getData = async ()=>{
    const { data  } = await _MainApi__WEBPACK_IMPORTED_MODULE_0__/* ["default"].get */ .Z.get(_ApiRoutes__WEBPACK_IMPORTED_MODULE_3__/* .basic_campaigns_api */ .KZ);
    return data;
};
function useGetBasicCampaigns() {
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useQuery)("basic-cam", getData, {
        enabled: false,
        onError: _api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_2__/* .onSingleErrorResponse */ .f$
    });
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 23897:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var helper_functions_getModuleId__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(52539);
/* harmony import */ var styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(45269);
/* harmony import */ var _ViewMore__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(35762);
/* harmony import */ var _CustomDivider__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(35740);
/* harmony import */ var helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(90603);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_ViewMore__WEBPACK_IMPORTED_MODULE_6__]);
_ViewMore__WEBPACK_IMPORTED_MODULE_6__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];










const GridItem = ({ category , handleClick , handleClickToSubCategory , hasChildLength , index  })=>{
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Box, {
        maxWidth: "150px",
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, {
                onClick: ()=>handleClick(category),
                fontSize: ".8rem",
                fontWeight: "500",
                sx: {
                    mb: category?.childes?.length > 0 ? "1.8rem" : hasChildLength()?.length === 0 ? ".7rem" : "1.4rem",
                    cursor: "pointer",
                    transition: "all ease 0.5s",
                    mt: hasChildLength()?.length === 0 && index !== 0 && ".7rem",
                    overflow: "hidden",
                    textOverflow: "ellipsis",
                    display: "-webkit-box",
                    WebkitLineClamp: "1",
                    WebkitBoxOrient: "vertical",
                    "&:hover": {
                        color: "primary.main",
                        letterSpacing: "0.03em"
                    }
                },
                children: category?.name
            }),
            category?.childes?.length > 0 && category?.childes?.slice(0, 5).map((item, index)=>{
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, {
                    sx: {
                        mb: "1rem",
                        cursor: "pointer",
                        fontSize: "0.75rem",
                        color: (theme)=>theme.palette.neutral[500],
                        transition: "all ease 0.5s",
                        "&:hover": {
                            color: "primary.main",
                            letterSpacing: "0.03em"
                        }
                    },
                    onClick: ()=>handleClickToSubCategory(item),
                    children: item?.name
                }, index);
            })
        ]
    });
};
const CategoryPopover = ({ handlePopoverCloseSub , categories  })=>{
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_4__.useRouter)();
    const handleClick = (item)=>{
        const query = (0,helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_8__/* .getCurrentModuleType */ .X)() === "rental" ? {
            pathname: "/rental/vehicle-search",
            query: {
                categoryId: item?.id
            }
        } : {
            pathname: "/home",
            query: {
                search: "category",
                id: item?.id,
                module_id: (0,helper_functions_getModuleId__WEBPACK_IMPORTED_MODULE_9__/* .getModuleId */ .S)(),
                name: btoa(item?.name),
                data_type: "category",
                from: "nav"
            }
        };
        router.push(query);
        handlePopoverCloseSub?.();
    };
    const handleClickToSubCategory = (item)=>{
        router.push({
            pathname: "/home",
            query: {
                search: "category",
                id: item?.id,
                module_id: `${(0,helper_functions_getModuleId__WEBPACK_IMPORTED_MODULE_9__/* .getModuleId */ .S)()}`,
                name: btoa(item?.name),
                data_type: "category"
            }
        });
        handlePopoverCloseSub?.();
    };
    const getGridSize = (length)=>{
        switch(length){
            case 1:
                return 6;
            case 2:
                return 4;
            case 3:
                return 3;
            case 4:
                return 2.4;
            case 5:
                return 2.4;
            default:
                return 12;
        }
    };
    const hasChildLength = ()=>{
        return categories?.slice?.(0, 5)?.filter((item)=>item?.childes?.length > 0 && item);
    };
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Box, {
        sx: {
            padding: "2rem",
            minWidth: "253px"
        },
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, {
            container: true,
            spacing: 3,
            children: [
                categories?.slice?.(0, 5)?.map((item, index)=>{
                    if (item?.childes?.length > 0) {
                        return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, {
                            item: true,
                            xs: getGridSize(hasChildLength()?.length),
                            children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_5__/* .CustomStackFullWidth */ .Xw, {
                                justifyContent: "space-between",
                                sx: {
                                    height: "100%"
                                },
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(GridItem, {
                                        category: item,
                                        handleClick: handleClick,
                                        handleClickToSubCategory: handleClickToSubCategory,
                                        hasChildLength: hasChildLength
                                    }),
                                    index === 0 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_ViewMore__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                                        redirect: "/categories",
                                        handlePopoverCloseSub: handlePopoverCloseSub,
                                        buttonType: "contained"
                                    })
                                ]
                            })
                        }, index);
                    }
                }),
                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Grid, {
                    item: true,
                    xs: getGridSize(hasChildLength()?.length),
                    children: [
                        categories?.slice?.(0, 5)?.map((item, index)=>{
                            if (!item?.childes || item?.childes?.length === 0) {
                                return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_5__/* .CustomStackFullWidth */ .Xw, {
                                    justifyContent: "space-between",
                                    children: [
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(GridItem, {
                                            hasChildLength: hasChildLength,
                                            category: item,
                                            handleClick: handleClick,
                                            handleClickToSubCategory: handleClickToSubCategory,
                                            index: index
                                        }),
                                        hasChildLength()?.length === 0 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomDivider__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                                            border: "1px"
                                        }),
                                        index === 0 && hasChildLength()?.length !== 0 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_ViewMore__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                                            redirect: "/categories",
                                            handlePopoverCloseSub: handlePopoverCloseSub,
                                            buttonType: "contained"
                                        })
                                    ]
                                }, item?.id);
                            }
                        }),
                        hasChildLength()?.length === 0 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Stack, {
                            mt: "1.4rem",
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_ViewMore__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                                redirect: "/categories",
                                handlePopoverCloseSub: handlePopoverCloseSub,
                                buttonType: "contained"
                            })
                        })
                    ]
                })
            ]
        })
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CategoryPopover);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 41790:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(69484);
/* harmony import */ var _mui_styles__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_styles__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(45269);
/* harmony import */ var _CategoryPopover__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(23897);
/* harmony import */ var helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(46573);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6022);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var api_manage_hooks_react_query_all_category_all_categorys__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(40291);
/* harmony import */ var redux_slices_storedData__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(8697);
/* harmony import */ var _NavStorePopover__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(84505);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_CategoryPopover__WEBPACK_IMPORTED_MODULE_5__, api_manage_hooks_react_query_all_category_all_categorys__WEBPACK_IMPORTED_MODULE_7__, _NavStorePopover__WEBPACK_IMPORTED_MODULE_9__]);
([_CategoryPopover__WEBPACK_IMPORTED_MODULE_5__, api_manage_hooks_react_query_all_category_all_categorys__WEBPACK_IMPORTED_MODULE_7__, _NavStorePopover__WEBPACK_IMPORTED_MODULE_9__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);











const useStyles = (0,_mui_styles__WEBPACK_IMPORTED_MODULE_3__.makeStyles)((theme)=>({
        popover: {
            pointerEvents: "none"
        },
        paper: {
            marginTop: "21px",
            pointerEvents: "auto"
        }
    }));
const NavPopover = ({ catImageUrl , open , anchorEl , handlePopoverOpenSub , openSub , anchorElSub , subCategory , popoverFor , handlePopoverCloseSub  })=>{
    const classes = useStyles();
    const { categories  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_6__.useSelector)((state)=>state.storedData);
    const rentalCategories = (0,react_redux__WEBPACK_IMPORTED_MODULE_6__.useSelector)((state)=>state?.rentalCategoriesLists?.rentalCategories);
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.useTheme)();
    const popoverDivId = (0,react__WEBPACK_IMPORTED_MODULE_1__.useId)();
    const { data: categoriesData , refetch , isFetched , isFetching , isLoading  } = (0,api_manage_hooks_react_query_all_category_all_categorys__WEBPACK_IMPORTED_MODULE_7__/* .useGetCategories */ .P)();
    const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_6__.useDispatch)();
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (categories.length === 0) {
            refetch();
        }
    }, []);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (categoriesData?.data) {
            dispatch((0,redux_slices_storedData__WEBPACK_IMPORTED_MODULE_8__/* .setCategories */ .DG)(categoriesData?.data));
        }
    }, [
        categoriesData
    ]);
    const popoverHandle = ()=>{
        if (popoverFor === "category") {
            if (categories?.length > 0 || rentalCategories?.length > 0) {
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CategoryPopover__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                    handlePopoverOpenSub: handlePopoverOpenSub,
                    catImageUrl: catImageUrl,
                    openSub: openSub,
                    anchorElSub: anchorElSub,
                    subCategory: subCategory,
                    handlePopoverCloseSub: handlePopoverCloseSub,
                    categories: (0,helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_10__/* .getModule */ .r)()?.module_type === "rental" ? rentalCategories : [
                        ...categories
                    ].sort((a, b)=>b?.childes?.length - a?.childes?.length)
                });
            }
        } else {
            return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_NavStorePopover__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {});
        }
    };
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__/* .CustomStackFullWidth */ .Xw, {
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Popover, {
            disableScrollLock: true,
            id: popoverDivId,
            open: open,
            anchorEl: anchorEl,
            anchorOrigin: {
                vertical: "bottom",
                horizontal: (0,helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_10__/* .getLanguage */ .G)() === "rtl" ? "right" : "left"
            },
            transformOrigin: {
                vertical: "top",
                horizontal: (0,helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_10__/* .getLanguage */ .G)() === "rtl" ? "right" : "left"
            },
            className: classes.popover,
            classes: {
                paper: classes.paper
            },
            children: popoverHandle()
        })
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NavPopover);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 84505:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(45269);
/* harmony import */ var _nav_store_component_NavPopularStores__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(22255);
/* harmony import */ var _nav_store_component_NavNewStore__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(37836);
/* harmony import */ var _nav_store_component_NavFoodCampaigns__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(82070);
/* harmony import */ var _api_manage_hooks_react_query_useGetBasicCampaigns__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(39794);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(6022);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var redux_slices_storedData__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(8697);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_nav_store_component_NavPopularStores__WEBPACK_IMPORTED_MODULE_5__, _nav_store_component_NavNewStore__WEBPACK_IMPORTED_MODULE_6__, _nav_store_component_NavFoodCampaigns__WEBPACK_IMPORTED_MODULE_7__, _api_manage_hooks_react_query_useGetBasicCampaigns__WEBPACK_IMPORTED_MODULE_8__]);
([_nav_store_component_NavPopularStores__WEBPACK_IMPORTED_MODULE_5__, _nav_store_component_NavNewStore__WEBPACK_IMPORTED_MODULE_6__, _nav_store_component_NavFoodCampaigns__WEBPACK_IMPORTED_MODULE_7__, _api_manage_hooks_react_query_useGetBasicCampaigns__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);











const NavStorePopover = ()=>{
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_3__.useTheme)();
    const bgColor = (0,_mui_material__WEBPACK_IMPORTED_MODULE_3__.alpha)(theme.palette.primary.main, 0.2);
    const { data , refetch , isLoading  } = (0,_api_manage_hooks_react_query_useGetBasicCampaigns__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z)();
    const { basicCampaigns  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_9__.useSelector)((state)=>state.storedData);
    const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_9__.useDispatch)();
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (basicCampaigns.length === 0) {
            refetch();
        }
    }, []);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (data) {
            dispatch((0,redux_slices_storedData__WEBPACK_IMPORTED_MODULE_10__/* .setBasicCampaigns */ .lh)(data));
        }
    }, [
        data
    ]);
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_2__.Stack, {
        width: basicCampaigns?.length > 0 ? "843px" : "500px",
        sx: {
            position: "relative",
            zIndex: "1",
            padding: "0px"
        },
        children: [
            basicCampaigns?.length > 0 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                style: {
                    position: "absolute",
                    zIndex: "-1",
                    blockSize: "100%",
                    inlineSize: "50%",
                    insetInlineEnd: "0",
                    insetBlockStart: "0",
                    display: "block",
                    backgroundColor: bgColor
                }
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_4__/* .CustomStackFullWidth */ .Xw, {
                sx: {
                    padding: "2.5rem"
                },
                children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Grid, {
                    container: true,
                    spacing: 2,
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Grid, {
                            item: true,
                            md: basicCampaigns?.length > 0 ? 3 : 6,
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_nav_store_component_NavPopularStores__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {})
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Grid, {
                            item: true,
                            md: basicCampaigns?.length > 0 ? 3 : 6,
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_nav_store_component_NavNewStore__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {})
                        }),
                        basicCampaigns?.length > 0 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Grid, {
                            item: true,
                            md: 6,
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_nav_store_component_NavFoodCampaigns__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                                campaigns: basicCampaigns,
                                isLoading: isLoading
                            })
                        })
                    ]
                })
            })
        ]
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NavStorePopover);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 35762:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45269);
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(22021);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(580);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var utils_staticTexts__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(76931);
/* harmony import */ var _mui_icons_material_ArrowForward__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(61883);
/* harmony import */ var _mui_icons_material_ArrowForward__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_ArrowForward__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(90603);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([i18next__WEBPACK_IMPORTED_MODULE_3__, utils_staticTexts__WEBPACK_IMPORTED_MODULE_7__]);
([i18next__WEBPACK_IMPORTED_MODULE_3__, utils_staticTexts__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);











const ViewMore = ({ redirect , handlePopoverCloseSub , buttonType  })=>{
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_5__.useRouter)();
    const handleClick = ()=>{
        handlePopoverCloseSub?.();
        if (redirect === "/categories") {
            const query = (0,helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_9__/* .getCurrentModuleType */ .X)() === "rental" ? {
                pathname: "/rental/vehicle-search",
                query: {
                    all_category: 1
                }
            } : {
                pathname: "/home",
                query: {
                    search: utils_staticTexts__WEBPACK_IMPORTED_MODULE_7__/* .VIEW_ALL_TEXT.allCategories */ .LK.allCategories,
                    from: "allCategories",
                    data_type: "category"
                }
            };
            router.push(query, undefined, {
                shallow: true
            });
        } else {
            router.push(redirect, undefined, {
                shallow: true
            });
        }
    };
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomStackFullWidth */ .Xw, {
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Button, {
            onClick: ()=>handleClick(),
            variant: buttonType ? buttonType : "outlined",
            sx: {
                width: "90px",
                textTransform: "capitalize",
                fontSize: "12px",
                fontWeight: "400",
                color: buttonType ? "whiteContainer.main" : "primary.main",
                boxShadow: (theme)=>`0px 23px 54px 0px ${(0,_mui_material__WEBPACK_IMPORTED_MODULE_4__.alpha)(theme.palette.primary.main, 0.05)}`,
                padding: "5px 5px"
            },
            children: [
                (0,i18next__WEBPACK_IMPORTED_MODULE_3__.t)("View all"),
                " ",
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_ArrowForward__WEBPACK_IMPORTED_MODULE_8___default()), {
                    sx: {
                        fontSize: "16px",
                        marginInlineStart: "5px"
                    }
                })
            ]
        })
    });
};
ViewMore.propTypes = {
    redirect: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string.isRequired)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ViewMore);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 82070:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(45269);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _CustomImageContainer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(58861);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(57987);
/* harmony import */ var _mui_icons_material_ArrowForward__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(61883);
/* harmony import */ var _mui_icons_material_ArrowForward__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_ArrowForward__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _ViewMore__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(35762);
/* harmony import */ var helper_functions_getModuleId__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(52539);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_8__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_i18next__WEBPACK_IMPORTED_MODULE_5__, _ViewMore__WEBPACK_IMPORTED_MODULE_7__]);
([react_i18next__WEBPACK_IMPORTED_MODULE_5__, _ViewMore__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);











const NavFoodCampaigns = ({ campaigns , isLoading  })=>{
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_8__.useRouter)();
    const { t  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.useTheme)();
    const handleClick = (e, item)=>{
        e.stopPropagation();
        router.push({
            pathname: "/campaigns/[id]",
            query: {
                id: `${item?.slug ? item?.slug : item?.id}`,
                module_id: `${(0,helper_functions_getModuleId__WEBPACK_IMPORTED_MODULE_9__/* .getModuleId */ .S)()}`
            }
        }, undefined, {
            shallow: true
        });
    };
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_1__/* .CustomStackFullWidth */ .Xw, {
        spacing: 4,
        sx: {
            height: "100%"
        },
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                variant: "h6",
                fontWeight: "500",
                textAlign: "center",
                children: t("Campaigns")
            }),
            campaigns?.length > 0 && campaigns?.slice(0, 3).map((item, index)=>{
                return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Stack, {
                    direction: "row",
                    justifyContent: "center",
                    alignItems: "center",
                    spacing: 2,
                    sx: {
                        cursor: "pointer"
                    },
                    onClick: (e)=>handleClick(e, item),
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomImageContainer__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                            src: item?.image_full_url,
                            width: "70px",
                            height: "70px",
                            borderRadius: ".5rem"
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Stack, {
                            width: "219px",
                            children: [
                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Stack, {
                                    direction: "row",
                                    alignItems: "center",
                                    spacing: 0.4,
                                    children: [
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                                            variant: "h6",
                                            color: theme.palette.primary.main,
                                            children: item?.title
                                        }),
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_ArrowForward__WEBPACK_IMPORTED_MODULE_6___default()), {
                                            sx: {
                                                color: (theme)=>theme.palette.primary.main,
                                                width: "20px",
                                                height: "20px"
                                            }
                                        })
                                    ]
                                }),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                                    fontSize: "13px",
                                    sx: {
                                        cursor: "pointer",
                                        overflow: "hidden",
                                        textOverflow: "ellipsis",
                                        display: "-webkit-box",
                                        WebkitLineClamp: "2",
                                        WebkitBoxOrient: "vertical"
                                    },
                                    children: item?.description
                                })
                            ]
                        })
                    ]
                }, index);
            }),
            isLoading && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Stack, {
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Skeleton, {
                    width: "100%",
                    height: 30
                })
            }),
            campaigns?.length > 3 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Stack, {
                height: "100%",
                width: "100%",
                sx: {
                    marginTop: "auto"
                },
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_ViewMore__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                    redirect: "/campaigns"
                })
            })
        ]
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NavFoodCampaigns);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 37836:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(57987);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6022);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _api_manage_hooks_react_query_store_useGetLatestStore__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(85296);
/* harmony import */ var _helper_functions_getModuleId__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(52539);
/* harmony import */ var _redux_slices_storedData__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(8697);
/* harmony import */ var _styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(45269);
/* harmony import */ var _ViewMore__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(35762);
/* harmony import */ var _NavStoreShimmer__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(54699);
/* harmony import */ var _helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(90603);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_i18next__WEBPACK_IMPORTED_MODULE_5__, _api_manage_hooks_react_query_store_useGetLatestStore__WEBPACK_IMPORTED_MODULE_7__, _ViewMore__WEBPACK_IMPORTED_MODULE_10__]);
([react_i18next__WEBPACK_IMPORTED_MODULE_5__, _api_manage_hooks_react_query_store_useGetLatestStore__WEBPACK_IMPORTED_MODULE_7__, _ViewMore__WEBPACK_IMPORTED_MODULE_10__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);














const NavNewStore = ()=>{
    const { configData  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_6__.useSelector)((state)=>state.configData);
    const { t  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    const newText = t("New On");
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_3__.useRouter)();
    const { data , refetch , isFetching  } = (0,_api_manage_hooks_react_query_store_useGetLatestStore__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z)();
    const { newStores  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_6__.useSelector)((state)=>state.storedData);
    const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_6__.useDispatch)();
    (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(()=>{
        if (newStores.length === 0) {
            refetch();
        }
    }, []);
    (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(()=>{
        if (data) {
            dispatch((0,_redux_slices_storedData__WEBPACK_IMPORTED_MODULE_8__/* .setNewStores */ .hT)(data?.stores));
        }
    }, [
        data
    ]);
    const handleClick = (item)=>{
        if ((0,_helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_12__/* .getCurrentModuleType */ .X)() === "rental") {
            router.push({
                pathname: `/rental/provider-details/${item?.id}`
            });
        } else {
            router.push({
                pathname: "/store/[id]",
                query: {
                    id: `${item?.slug ? item?.slug : item?.id}`,
                    module_id: `${(0,_helper_functions_getModuleId__WEBPACK_IMPORTED_MODULE_13__/* .getModuleId */ .S)()}`,
                    module_type: (0,_helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_12__/* .getCurrentModuleType */ .X)(),
                    store_zone_id: `${item?.zone_id}`,
                    distance: item?.distance
                }
            });
        }
    };
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_9__/* .CustomStackFullWidth */ .Xw, {
        spacing: 4,
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, {
                variant: "h7",
                fontWeight: "500",
                children: `${newText} ${configData?.business_name}`
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_2__.Stack, {
                width: "100%",
                spacing: 2.5,
                children: [
                    !isFetching ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                        children: newStores?.slice(0, 6).map((store)=>{
                            return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_2__.Stack, {
                                width: "100%",
                                onClick: ()=>handleClick(store),
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_9__/* .CustomTypographyGray */ .mI, {
                                    variant: "subtitle2",
                                    sx: {
                                        fontWeight: "400",
                                        cursor: "pointer",
                                        lineHeight: "20px",
                                        transition: "all ease 0.5s",
                                        "&:hover": {
                                            letterSpacing: "0.02em",
                                            color: (theme)=>theme.palette.primary.main
                                        }
                                    },
                                    children: store.name
                                })
                            }, store.id);
                        })
                    }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_2__.Stack, {
                        width: "100%",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_NavStoreShimmer__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z, {})
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_2__.Stack, {
                        width: "70%",
                        justifyContent: "flex-start",
                        alignItems: "center",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_ViewMore__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z, {
                            redirect: (0,_helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_12__/* .getCurrentModuleType */ .X)() === "rental" ? "/rental/provider/latest" : "/store/latest"
                        })
                    })
                ]
            })
        ]
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NavNewStore);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 22255:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45269);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(57987);
/* harmony import */ var _api_manage_hooks_react_query_store_useGetPopularStore__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63051);
/* harmony import */ var _ViewMore__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(35762);
/* harmony import */ var _NavStoreShimmer__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(54699);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(6022);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var helper_functions_getModuleId__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(52539);
/* harmony import */ var helper_functions_getStoresOrRestaurants__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(37698);
/* harmony import */ var redux_slices_storedData__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(8697);
/* harmony import */ var helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(90603);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_i18next__WEBPACK_IMPORTED_MODULE_5__, _api_manage_hooks_react_query_store_useGetPopularStore__WEBPACK_IMPORTED_MODULE_6__, _ViewMore__WEBPACK_IMPORTED_MODULE_7__, helper_functions_getStoresOrRestaurants__WEBPACK_IMPORTED_MODULE_11__]);
([react_i18next__WEBPACK_IMPORTED_MODULE_5__, _api_manage_hooks_react_query_store_useGetPopularStore__WEBPACK_IMPORTED_MODULE_6__, _ViewMore__WEBPACK_IMPORTED_MODULE_7__, helper_functions_getStoresOrRestaurants__WEBPACK_IMPORTED_MODULE_11__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);















const NavPopularStore = ()=>{
    const { t  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    const type = "all";
    const filterBy = "all";
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_9__.useRouter)();
    const pageLimit = 12;
    const { data , refetch , isFetching  } = (0,_api_manage_hooks_react_query_store_useGetPopularStore__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z)({
        type,
        offset: 1,
        limit: pageLimit
    });
    const { popularStores  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_10__.useSelector)((state)=>state.storedData);
    const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_10__.useDispatch)();
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (popularStores.length === 0) {
            refetch();
        }
    }, []);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (data && data?.pages?.length > 0 && data?.pages?.[0]?.stores?.length > 0) {
            dispatch((0,redux_slices_storedData__WEBPACK_IMPORTED_MODULE_12__/* .setPopularStores */ .Ww)(data?.pages?.[0]?.stores));
        }
    }, [
        data
    ]);
    const handleClick = (item)=>{
        if ((0,helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_13__/* .getCurrentModuleType */ .X)() === "rental") {
            router.push({
                pathname: `/rental/provider-details/${item?.id}`
            });
        } else {
            router.push({
                pathname: "/store/[id]",
                query: {
                    id: `${item?.slug ? item?.slug : item?.id}`,
                    module_id: `${(0,helper_functions_getModuleId__WEBPACK_IMPORTED_MODULE_14__/* .getModuleId */ .S)()}`,
                    module_type: (0,helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_13__/* .getCurrentModuleType */ .X)(),
                    store_zone_id: `${item?.zone_id}`,
                    distance: item?.distance
                }
            });
        }
    };
    const popular = t("Popular");
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomStackFullWidth */ .Xw, {
        spacing: 4,
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Typography, {
                variant: "h7",
                fontWeight: "500",
                children: t(`${popular} ${(0,helper_functions_getStoresOrRestaurants__WEBPACK_IMPORTED_MODULE_11__/* .getStoresOrRestaurants */ .s)()}`)
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_4__.Stack, {
                width: "100%",
                spacing: 2.5,
                children: [
                    !isFetching ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                        children: popularStores?.length > 0 && popularStores?.slice(0, 6).map((store)=>{
                            return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_4__.Stack, {
                                width: "100%",
                                onClick: ()=>handleClick(store),
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomTypographyGray */ .mI, {
                                    variant: "subtitle2",
                                    sx: {
                                        fontWeight: "400",
                                        cursor: "pointer",
                                        transition: "all ease 0.5s",
                                        overflow: "hidden",
                                        textOverflow: "ellipsis",
                                        display: "-webkit-box",
                                        WebkitLineClamp: "1",
                                        WebkitBoxOrient: "vertical",
                                        "&:hover": {
                                            letterSpacing: "0.02em",
                                            color: (theme)=>theme.palette.primary.main
                                        }
                                    },
                                    children: store.name
                                })
                            }, store.id);
                        })
                    }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_4__.Stack, {
                        width: "100%",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_NavStoreShimmer__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {})
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_4__.Stack, {
                        width: "70%",
                        justifyContent: "flex-start",
                        alignItems: "center",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_ViewMore__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                            redirect: (0,helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_13__/* .getCurrentModuleType */ .X)() === "rental" ? "/rental/provider/popular" : "/store/popular"
                        })
                    })
                ]
            })
        ]
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NavPopularStore);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 54699:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45269);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_4__);





const NavStoreShimmer = ()=>{
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomStackFullWidth */ .Xw, {
        spacing: 0.5,
        children: [
            ...Array(10)
        ].map((item, index)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Stack, {
                spacing: 3,
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Skeleton, {
                    width: 150,
                    height: 20
                })
            }, index))
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NavStoreShimmer);


/***/ })

};
;